%%%
%%% Q_AUTOSCALE: AUTOSCALE IMAGE.
%%%
%%%		Adjust display so that the image fills the entire
%%%		range from black to white - that is, the minimal image
%%%		pixel value is mapped to black, and the maximal pixel
%%%		value is mapped to white.  Adjustment is done on the
%%%		colormap axis: get(gca,'Clim');
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_autoscale( parent );

	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	IM.clim	= [ min(IM.im(:)) max(IM.im(:)) ];
	Q_show_im( IM, parent );
	Q_active( parent, 0 );	
