%%%
%%% Q_ADDNOISE: ADD NOISE TO IMAGE.
%%%
%%%		Add zero mean white noise (i.e. noise drawn from a
%%%		uniform distribution) to an image.  Control the
%%%		amount of noise, specified in pixel intensities.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_addnoise( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	Q_window( parent );
	Q_sliders( parent, IM );
	Q_callbacks( parent );
	Q_addnoise( str2num(sprintf('%d',parent)), 0, 1 );
else 
	if( mode == 1 | mode == 2 ) % PREVIEW
		vals	= Q_getvals( parent, mode );	
		IM	= Q_get_iminfo( parent );
		im2	= noise( Q_make_preview_im(IM.im), vals );
		Q_preview_im( im2, parent, 0 );
	elseif( mode == 3 ) % OK
		vals	= Q_getvals( parent, mode );	
		IM	= Q_get_iminfo( parent );
		IM.im	= noise( IM.im, vals );
		Q_resetfig( parent, IM );
		return;
	end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'Add Noise', 1, 1 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent, IM )

	H 	= Q_get_handles( parent );

	limit		= max( abs(IM.im(:)) );
	step1		= min( 0.01*limit, 0.01 );
	step2		= min( 0.1*limit, 0.1 );
	
	%%% SLIDER/EDIT/LABEL
	H.temp(1) = Q_input( parent, [0.6 0.37 0.25 0.06], ...
				[0 limit 0 step1 step2], 'slider' );
	H.temp(2) = Q_input( parent, [0.86 0.37 0.12 0.06], 0, 'edit' );
	H.temp(3) = Q_input( parent, [0.86 0.30 0.12 0.06], ...
				'Noise Level (pixel intensity)', 'text' );

	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H 	= Q_get_handles( parent );
	cmd1 	= sprintf( 'Q_addnoise(%d,0,1);', parent );
	cmd2 	= sprintf( 'Q_addnoise(%d,0,2);', parent );
	cmd3 	= sprintf( 'Q_addnoise(%d,0,3);', parent );

	%%% SLIDER/EDIT
	set( H.temp(1), 'Callback', cmd1 );
	set( H.temp(2), 'Callback', cmd2 );
	set( H.ok, 'Callback', cmd3 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent, mode )

	H	= Q_get_handles( parent );

	if( mode == 1 | mode == 3 | mode == 4 ) % SLIDER INPUT
		r	= round(100*get( H.temp(1), 'Value' ))/100;
		set(  H.temp(2), 'String', r );
	elseif( mode == 2 ) % EDIT INPUT
		r	= str2num( get( H.temp(2), 'String' ) );
		if( isempty(r) ) r = 0; end;
		r	= max( r, get(  H.temp(1), 'Min' ) );
		r	= min( r, get(  H.temp(1), 'Max' ) );
		set( H.temp(1), 'Value', r );
		set( H.temp(2), 'String', r );
	end

	vals 	= r;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[ im2 ] = noise( im, r )
	
	if( r == 0 )
		im2 = im;
	else
		im2 = im + r * ( rand( size(im) ) - 0.5 );
	end