%%%
%%% Q_ACTIVE: 	NON-MENU ROUTINE. 
%%%
%%%		Don't allow a new menu option to be perfomed until the
%%%		current menu option is completed.  Before executing a
%%%		menu option check: 
%%%			if( Q_active(parent,1) )
%%%				return;
%%%			end
%%%
%%%		Active status is reset in Q_resetfig.m
%%%			Q_active(parent,0);
%%%
%%%		Active status is stored at top level of figure
%%%		UserData.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[ active ] = Q_active( parent, status )

	H		= get( parent, 'UserData' );
	active		= H.active;	% return current status
	H.active	= status;	% reset stauts
	set( parent, 'UserData', H )
