%%%
%%% Q: 		GET THINGS STARTED.
%%%
%%% USAGE:	>> Q 
%%%		create a new Q figure with a default image.
%%%
%%%		>> Q(im)
%%%		load an existing image into a new Q figure.
%%%
%%%		>> Q(im,fig)
%%%		load an existing image into an existing or new Q
%%%		figure, fig specified figure number.
%%%
%%%		>> Q(im,fig,name,cmap,clim,magnify)
%%%		load an existing image into an existing or new Q
%%%		figure with specified name (string), colormap (256x3
%%%		matrix), colormap axis (2 vector), and magnification
%%%		(1/8, 1/4, 1/2, 1, 2, 4, 8).
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [parent] = Q( im, parent, name, cmap, clim, magnify )

	if( exist( 'parent' ) )
		if( Q_active(parent,1) )
			return;
		end
	end

	defaults = Q_defaults( 'all' );

	if( ~exist('im') == 1 ) 		
		im = defaults.im;
	end
	if( ~exist('cmap') == 1 )		
		cmap = defaults.cmap;
	end
	if( ~exist('clim') == 1 )		
		clim = defaults.clim;
	end
	if( ~exist('magnify') == 1 )	
		magnify = defaults.magnify; 
	end
	if( ~exist('name') == 1 )  
		name = defaults.filename;
	end
	if( ~exist('mode') == 1 )  
		mode = defaults.mode;
	end

	if( exist( 'parent' ) == 1 )
		Q_main( im, cmap, clim, magnify, mode, name, parent );
	else
		parent = Q_main( im, cmap, clim, magnify, mode, name );
	end

	Q_active( parent, 0 );