function xform = vsdComputeReg(destImg,sourceImg,xform,crop);
%
% newXform = vsdComputeReg(destImage,sourceImage,xform,[crop]);
%
% djh 7/2006. Modified from mrAlign code originally written by Oscar
% Nestares.

if ieNotDefined('crop')
	crop = [];
end

MAXITER = 10;   % query user to continue after this number of iterations
MINDISP = 1;  % displacement used to end the iterations
CB = 2.5;       % cutoff parameter for robust estimation
SC = 2;         % scaling parameter for robust estimation

% resample the sourceImg
wbh = waitbar(0,'Resampling source image and applying intensity/contrast correction...');
xformImg = transformImage(sourceImg,size(destImg),xform);

% intensity/contrast correction
destImgIC = vsdIntensityContrastCorrection(destImg,crop);
xformImgIC = vsdIntensityContrastCorrection(xformImg,crop);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Robust, affine alignment %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Loop until the approximate maximum displacement is less than MINDISP, or
% the maximum number of iterations is reached. The maximum displacement is
% calculated aproximately from the sum of terms - the displacement
% corresponding to the rotation of the farthest point in the inplanes, plus
% the norm of the translation.

TOTiter = 0;
UserResponse = 'Yes';
while strcmp(UserResponse, 'Yes')
	niter = 0;
	maxDisp = MINDISP + 1;

	while ((maxDisp > MINDISP) & (niter < MAXITER))
		
		% updating number of iterations and message in progress bar
		niter = niter+1;
		TOTiter = TOTiter+1;
		set(get(get(wbh,'Children'),'Title'),'String',...
			['Alignment, iter = ',num2str(TOTiter),'...']);
		waitbar((niter+1)/(MAXITER+1));

		% motion estimation (no multiresolution, one iteration)
		M = estMotion2(destImgIC,xformImgIC,...
			0,...                % rotFlag
			1,...                % robustFlag
			crop,...             % crop region
			CB,...               % cutoff parameter for robust estimation
			SC);                 % scale parameter for robust estimation

		% update xform and recompute intensity/contrast correction
		xform = M * xform;
		xformImg = transformImage(sourceImg,size(destImg),xform);
		xformImgIC = vsdIntensityContrastCorrection(xformImg,crop);
		maxDisp = norm(size(destImg)' - M(1:2,1:2)*size(destImg)') + norm(M(1:2,3));
		
	end

	if (niter == MAXITER)
		% question asking if we should continue iterating
		QUEST = strvcat(['Maximum number of iterations (',num2str(MAXITER),') reached.'], '          CONTINUE ITERATING?');
		UserResponse = questdlg(QUEST, 'WARNING', 'Yes', 'No', 'No');
	else
		UserResponse = 'No';
	end
end

close(wbh);
