function varargout = vsdAlignGUI(varargin)
% vsdAlignGUI (called by vsdAlign)
% created by GUIDE
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Last Modified by GUIDE v2.5 30-Jul-2006 09:50:20

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @vsdAlignGUI_OpeningFcn, ...
                   'gui_OutputFcn',  @vsdAlignGUI_OutputFcn, ...
                   'gui_LayoutFcn',  [], ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before vsdAlignGUI is made visible.
function vsdAlignGUI_OpeningFcn(hObject, eventdata, handles, varargin)
global ALIGN

% Initialize ALIGN global variable
ALIGN.destPath = [];
ALIGN.destSize = [64 64];
ALIGN.sourcePath = [];
ALIGN.xform = eye(3);

% Initialize GUI
set(handles.transposeButton,'Value',0);
set(handles.flipButton,'Value',0);
set(handles.overlayButton,'Value',1);
set(handles.transparencySlider,'Value',1);
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'trans',[0 0]);
refreshAlignDisplay(handles);

% Choose default command line output for vsdAlignGUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = vsdAlignGUI_OutputFcn(hObject, eventdata, handles)
% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on mouse press over axes background.
function axes_ButtonDownFcn(hObject, eventdata, handles)

% --- Executes on button press in overlayButton.
function overlayButton_Callback(hObject, eventdata, handles)
refreshAlignDisplay(handles);

% --- Executes on button press in transposeButton.
function transposeButton_Callback(hObject, eventdata, handles)
refreshAlignDisplay(handles);

% --- Executes on button press in flipButton.
function flipButton_Callback(hObject, eventdata, handles)
refreshAlignDisplay(handles);

% --- Executes during object creation, after setting all properties.
function transparencySlider_CreateFcn(hObject, eventdata, handles)
usewhitebg = 1;
if usewhitebg
    set(hObject,'BackgroundColor',[.9 .9 .9]);
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes on slider movement.
function transparencySlider_Callback(hObject, eventdata, handles)
global ALIGN
refreshAlignDisplay(handles);

% --- Executes during object creation, after setting all properties.
function transX_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function transX_Callback(hObject, eventdata, handles)
global ALIGN
refreshAlignDisplay(handles);

% --- Executes during object creation, after setting all properties.
function transY_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function transY_Callback(hObject, eventdata, handles)
global ALIGN
refreshAlignDisplay(handles);

% --- Executes during object creation, after setting all properties.
function scale_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function scale_Callback(hObject, eventdata, handles)
global ALIGN
refreshAlignDisplay(handles);

% --- Executes during object creation, after setting all properties.
function rotZ_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function rotZ_Callback(hObject, eventdata, handles)
global ALIGN
refreshAlignDisplay(handles);


% --------------------------------------------------------------------
function fileMenu_Callback(hObject, eventdata, handles)

% --------------------------------------------------------------------
function loadDestMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
% Prompt user to choose image file
initPath = pwd;
pathStr = getPathStrDialog(initPath,'Choose image file','*.mat');
ALIGN.destPath = pathStr;
% Load image
load(pathStr);
if ieNotDefined('Im')
	error('No image in: ',pathStr);
end
ALIGN.destImage = double(Im);
% Update ALIGN structure and GUI
ALIGN.destSize = size(ALIGN.destImage);
ALIGN.destClip = clipRange(ALIGN.destImage);
% Reset alignment to identity.
ALIGN.xform = eye(3);
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'trans',[0 0]);
% Refresh GUI
refreshAlignDisplay(handles);

function cRange = clipRange(image)
% Choose clipping based on histogram
histThresh = length(image(:))/1000;
[cnt, val] = hist(image(:),100);
goodVals = find(cnt>histThresh);
clipMin = val(min(goodVals));
clipMax = val(max(goodVals));
cRange = [clipMin,clipMax];

% --------------------------------------------------------------------
function loadSourceMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
% Prompt user to choose image file 
initPath = pwd;
pathStr = getPathStrDialog(initPath,'Choose alignment file','*.mat');
ALIGN.sourcePath = pathStr;
% Load image
load(pathStr);
if ieNotDefined('Im')
	error('No image in: ',pathStr);
end
ALIGN.sourceImage = double(Im);
% Update ALIGN structure
ALIGN.sourceClip = clipRange(ALIGN.sourceImage);
% Reset alignment to identity.
ALIGN.xform = eye(3);
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'trans',[0 0]);
% Refresh GUI
refreshAlignDisplay(handles);

% --------------------------------------------------------------------
function saveAlignMenuItem_Callback(hObject, eventdata, handles)
global ALIGN

xform = concatenateXforms(ALIGN.xform,...
	getAlignGUI(handles,'rot'),...
	getAlignGUI(handles,'trans'),...
	getAlignGUI(handles,'scale'),...
	size(ALIGN.destImage)/2);
ALIGN.xform = xform;
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'trans',[0 0]);
% Construct filename
[sourcePath,sourceName,sourceExt,sourceVersn] = fileparts(ALIGN.sourcePath);
[destPath,destName,destExt,destVersn] = fileparts(ALIGN.destPath);
xformFile = [sourceName,'-to-',destName,'.mat'];
save(xformFile,'xform');
% Print it
xform

% --------------------------------------------------------------------
function loadAlignMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
% Prompt user to choose image file 
initPath = pwd;
pathStr = getPathStrDialog(initPath,'Choose image file','*.mat');
% Load xform
load(pathStr);
if ieNotDefined('xform')
	error('No xform in: ',pathStr);
end
ALIGN.xform = xform;
% Reset GUI.
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'trans',[0 0]);
% Refresh GUI
refreshAlignDisplay(handles);

% --------------------------------------------------------------------
function writeTifMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
pathstr = putPathStrDialog(pwd,'Specify alignment file','*.tif');
% pathstr = [] if aborted
if ~isempty(pathstr)
	img = refreshAlignDisplay(handles);
	imwrite(img,pathstr,'tif');
end

% --------------------------------------------------------------------
function quitMenuItem_Callback(hObject, eventdata, handles)
clear global ALIGN
delete(handles.figure1);


% --------------------------------------------------------------------
function manualAlignmentMenu_Callback(hObject, eventdata, handles)

% --------------------------------------------------------------------
function initializeIdentityMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
ALIGN.xform = eye(3);
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'trans',[0 0]);
refreshAlignDisplay(handles);

% --------------------------------------------------------------------
function flipXMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
xform = concatenateXforms(ALIGN.xform,...
	getAlignGUI(handles,'rot'),...
	getAlignGUI(handles,'trans'),...
	getAlignGUI(handles,'scale'),...
	size(ALIGN.destImage)/2);
ALIGN.xform = xform * [-1 0 size(ALIGN.sourceImage,2); 0 1 0; 0 0 1];
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'trans',[0 0]);
refreshAlignDisplay(handles);

% --------------------------------------------------------------------
function flipYMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
xform = concatenateXforms(ALIGN.xform,...
	getAlignGUI(handles,'rot'),...
	getAlignGUI(handles,'trans'),...
	getAlignGUI(handles,'scale'),...
	size(ALIGN.destImage)/2);
ALIGN.xform = xform * [1 0 0; 0 -1 size(ALIGN.sourceImage,1); 0 0 1];
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'trans',[0 0]);
refreshAlignDisplay(handles);


% --------------------------------------------------------------------
function computeAlignmentMenu_Callback(hObject, eventdata, handles)

% --------------------------------------------------------------------
function cropInplanesMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
ALIGN.crop = selectCrop2(ALIGN.destImage);

% --------------------------------------------------------------------
function coarseMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
if isempty(ALIGN.destImage) | isempty(ALIGN.sourceImage)
	mrWarnDlg('Load source and destination images before computing alignment');
	return
end
% current xform
xform = concatenateXforms(ALIGN.xform,...
	getAlignGUI(handles,'rot'),...
	getAlignGUI(handles,'trans'),...
	getAlignGUI(handles,'scale'),...
	size(ALIGN.destImage)/2);
% reduce images
bfilt=[.0625 .25 .375 .25 .0625]';
tmp1 = conv2sep(ALIGN.destImage,bfilt,bfilt,'valid');
tmp2 = conv2sep(ALIGN.sourceImage,bfilt,bfilt,'valid');
destImageSmall = tmp1(1:2:size(tmp1,1),1:2:size(tmp1,2));
sourceImageSmall = tmp2(1:2:size(tmp2,1),1:2:size(tmp2,2));
% reduce xform & crop
xform(1:2,3) = xform(1:2,3)/2;
crop = floor(ALIGN.crop/2);
% compute registration
xform = vsdComputeReg(destImageSmall,sourceImageSmall,xform,crop);
% expand new xform
xform(1:2,3) = xform(1:2,3)*2;
% update structures and gui
ALIGN.xform = xform;
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'trans',[0 0]);
refreshAlignDisplay(handles);

% --------------------------------------------------------------------
function fineMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
if isempty(ALIGN.destImage) | isempty(ALIGN.sourceImage)
	mrWarnDlg('Load source and destination images before computing alignment');
	return
end
xform = concatenateXforms(ALIGN.xform,...
	getAlignGUI(handles,'rot'),...
	getAlignGUI(handles,'trans'),...
	getAlignGUI(handles,'scale'),...
	size(ALIGN.destImage)/2);
ALIGN.xform = vsdComputeReg(ALIGN.destImage,ALIGN.sourceImage,xform,ALIGN.crop);
setAlignGUI(handles,'rot',0);
setAlignGUI(handles,'scale',1);
setAlignGUI(handles,'trans',[0 0]);
refreshAlignDisplay(handles);


% --------------------------------------------------------------------
function checkAlignmentMenu_Callback(hObject, eventdata, handles)

% --------------------------------------------------------------------
function checkWithCorrectionMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
if isempty(ALIGN.destImage) | isempty(ALIGN.sourceImage)
	mrWarnDlg('Load Volume and Load Inplanes before checking alignment.');
	return
end
if isempty(ALIGN.xform) 
	mrWarnDlg('Load, Initialize, or Compute the alignment before checking it.');
	return
end
xform = concatenateXforms(ALIGN.xform,...
	getAlignGUI(handles,'rot'),...
	getAlignGUI(handles,'trans'),...
	getAlignGUI(handles,'scale'),...
	size(ALIGN.destImage)/2);
vsdAlignCheck(ALIGN.destImage,ALIGN.sourceImage,xform,1,ALIGN.crop)

% --------------------------------------------------------------------
function checkWithoutCorrectionMenuItem_Callback(hObject, eventdata, handles)
global ALIGN
if isempty(ALIGN.destImage) | isempty(ALIGN.sourceImage)
	mrWarnDlg('Load Volume and Load Inplanes before checking alignment.');
	return
end
if isempty(ALIGN.xform) 
	mrWarnDlg('Load, Initialize, or Compute the alignment before checking it.');
	return
end
xform = concatenateXforms(ALIGN.xform,...
	getAlignGUI(handles,'rot'),...
	getAlignGUI(handles,'trans'),...
	getAlignGUI(handles,'scale'),...
	size(ALIGN.destImage)/2);
vsdAlignCheck(ALIGN.destImage,ALIGN.sourceImage,xform,0)

% --- Executes during object deletion, before destroying properties.
function axes_DeleteFcn(hObject, eventdata, handles)
clear global ALIGN


