function vsdAlignCheck(destImg,sourceImg,xform,correction,crop)
% vsdAlignCheck(destImg,sourceImg,xform,correction,crop)
%
% Resamples the source image according to xform and displays it interleaved
% as a checkerboard mosaic with the destination image.
%
% djh 7/2006
% Modified from mrAlign code originally written by Oscar Nestares

if ieNotDefined('correction')
	correction = 0;
end

% resample the sourceImg
xformImg = transformImage(sourceImg,size(destImg),xform);

if correction
	destImgIC = vsdIntensityContrastCorrection(destImg,crop);
	xformImgIC = vsdIntensityContrastCorrection(xformImg,crop);
else
	destImgIC = destImg;
	xformImgIC = xformImg;
end

% checking the alignment
FF = figure;
SS = get(0,'ScreenSize');
set(FF,'Position', [1 -40 SS(3)/3  SS(4)-80])
figure(FF)
subplot(3,1,1)
imagesc(xformImg);
axis('image'); colormap('gray'); axis('off');
subplot(3,1,2)
imagesc(mosaic(xformImgIC,destImgIC));
axis('image'); colormap('gray'); axis('off');
subplot(3,1,3)
imagesc(destImg);
axis('image'); colormap('gray'); axis('off');
