function img = refreshAlignGUI(handles)

global ALIGN

xform = concatenateXforms(ALIGN.xform,...
	getAlignGUI(handles,'rot'),...
	getAlignGUI(handles,'trans'),...
	getAlignGUI(handles,'scale'),...
	size(ALIGN.destImage)/2);

% Just return if volume hasn't been loaded yet.
if isempty(ALIGN.destImage)
    return
end
    
% Make mrAlign the current figure and raise it
figure(handles.figure1)

% Extract base and overlay images
% Convert to RGB
alpha = get(handles.transparencySlider,'Value');
if ~isempty(ALIGN.destImage)
	base = ALIGN.destImage;
    baseRGB = rescale2rgb(base,ALIGN.baseCmap,ALIGN.destClip);
end
if ~isempty(ALIGN.sourceImage) & ~isempty(xform)
    overlay = transformImage(ALIGN.sourceImage,ALIGN.destSize,xform);
    overlayRGB = rescale2rgb(overlay,ALIGN.overlayCmap,ALIGN.sourceClip);
end

% Figure out what to display depending on status of overlay button and
% whether or not base and overlay images exist.
if get(handles.overlayButton,'Value')
	if exist('baseRGB','var') & exist('overlayRGB','var')
		alphaMap = repmat(alpha * ~isnan(overlay),[1 1 3]);
		img = (1-alphaMap).*baseRGB + alphaMap.*overlayRGB;
	elseif exist('baseRGB','var')
		img = baseRGB;
	elseif exist('overlayRGB','var')
		img = overlayRGB;
	end
elseif exist('baseRGB','var')
	img = baseRGB;
end

% Transpose and flip
if exist('img','var')
    if get(handles.transposeButton,'Value')
        imgSize = size(img);
        imgTranspose = zeros(imgSize(2), imgSize(1), imgSize(3));
        for c = 1:3
            imgTranspose(:,:,c) = img(:,:,c)';
        end
        img = imgTranspose;
    end
    if get(handles.flipButton,'Value')
        img = flipdim(img,1);
	end
else
	img = [];
end

% Display it
if ~isempty(img)
    image(img);
    axis off
    axis image
end


function rgb = rescale2rgb(image,cmap,clip)
%function rgb = rescale2rgb(image,cmap,[clipMin,clipMax])

if ~exist('clip','var')
    % Choose clipping based on histogram
    histThresh = length(image(:))/1000;
    [cnt, val] = hist(image(:),100);
    goodVals = find(cnt>histThresh);
    clipMin = val(min(goodVals));
    clipMax = val(max(goodVals));
    clip = [clipMin,clipMax];
else
    clipMin = clip(1);
    clipMax = clip(2);
end

% Clip
result = image;
result(find(image < clipMin)) = clipMin;
result(find(image > clipMax)) = clipMax;

% Scale
indices = round(255 * (result-clipMin)/(clipMax-clipMin)) + 1;
indices = max(1,min(indices,size(cmap,1)));

% Extract r,g,b components
r = zeros(size(image));
g = zeros(size(image));
b = zeros(size(image));
r(:) = cmap(indices,1);
g(:) = cmap(indices,2);
b(:) = cmap(indices,3);

% Stuff them into rgb
dims = [size(image),3];
rgb = cat(length(dims),r,g,b);
