function value = getAlignGUI(handles,field)
% function value = getAlignGUI(handles,field)
%
% djh 7/8/2004

switch field	
	case 'scale'
		value = str2double(get(handles.scale,'String'));
		% str2double returns nan for non-numeric strings, change to zeros
		nanIndices = find(isnan(value));
		value(nanIndices) = zeros(size(nanIndices));

	case 'trans'
		value = [str2double(get(handles.transX,'String')),...
				str2double(get(handles.transY,'String'))];
		% str2double returns nan for non-numeric strings, change to zeros
		nanIndices = find(isnan(value));
		value(nanIndices) = zeros(size(nanIndices));
		
	case 'rot'
		% Extract from GUI
		theta = str2double(get(handles.rotZ,'String'));
		% str2double returns nan for non-numeric strings, change to zeros
		nanIndices = find(isnan(theta));
		theta(nanIndices) = zeros(size(nanIndices));
		
		% Convert from deg to radians
		theta = pi/180 * theta;
		
		% Stuff into 2x2 rotation matrix
		value = eye(3);
		cosTheta = cos(theta);		
		sinTheta = sin(theta);
		value(1,1) = cosTheta;
		value(1,2) = sinTheta;
		value(2,1) = -sinTheta;
		value(2,2) = cosTheta;

	otherwise
		warndlg('Invalid field for getAlignGUI');
end
