function newXform = concatenateXforms(xform,rot,trans,scale,center)
% function xform = concatenateXforms(xform,rot,trans,scale,center)
%
% Constructs a 3x3 homogeneous transform matrix from
%   xform: current 3x3 transform
%   rot: 2x2 rotation matrix
%   trans: translation vector
%   scale: scale factor
%
% djh, 7/2007

centerXform = eye(3);
centerXform(1,3) = -center(1);
centerXform(2,3) = -center(2);
recenterXform = eye(3);
recenterXform(1,3) = center(1);
recenterXform(2,3) = center(2);

transScale = eye(3);
transScale(1,1) = scale;
transScale(2,2) = scale;
transScale(1,3) = trans(1);
transScale(2,3) = trans(2);

newXform = transScale * recenterXform * rot * centerXform * xform;
