function result = transformImage(image,destSize,xform)

[x,y] = meshgrid(1:destSize(1),1:destSize(2));

dims = size(x);
numPixels = prod(dims);
xvec = reshape(x,1,numPixels);
yvec = reshape(y,1,numPixels);
coords = [xvec; yvec; ones(1,numPixels)];
coordsXform = xform * coords;
xi = reshape(coordsXform(1,:),dims);
yi = reshape(coordsXform(2,:),dims);
result = interp2(image,xi,yi,'linear',0);
