function cropRegion = selectCrop2(img)
% function cropRegion = selectCrop2(volume)

h = figure('MenuBar', 'none');
OK = 0;    % Flag to accept chosen crop
while ~OK
	% Display image
    clf
    imagesc(img);
    colormap(gray)
    brighten(0.6);
    axis off
    axis equal
    title('Crop the image.')

	% Get user input
    [y,x] = ginput(2);
	% y = size(img,2) - y;	
    x = sort(round(x));
    y = sort(round(y));
    x = max(1, min(x, size(img, 1)));
    y = max(1, min(y, size(img, 2)));
    
	% Set cropRegion
    cropRegion = [x(1), y(1); x(2), y(2)];

    % Confirm crop
	clf
    imgCrop = img([cropRegion(1,1):cropRegion(2,1)], ...
        [cropRegion(1,2):cropRegion(2,2)]);
	imagesc(imgCrop);
	colormap(gray)
	brighten(0.6);
	axis off
	axis equal   

    switch questdlg('Does this look OK?', 'Confirm crop');
        case 'Cancel'
            % Cancel
            cropRegion = [1, 1; size(img)];
            disp('Crop aborted');
            OK = 1;
        case 'Yes'
            % Okay
            OK = 1;
        case 'No'
            % No
            disp('Repeating crop');
    end
end  %if ~OK

close(h)

