% Compute rotation matrix from rotational velocity.

function R = rotation_matrix(C)
w = sqrt(C(1)*C(1) + C(2)*C(2) + C(3)*C(3)); %Rotation angle (rad) 
t1 = sin(w*0.5);
Q = [cos(w*0.5) C(1)/w*t1 C(2)/w*t1 C(3)/w*t1];

R = [Q(1)^2+Q(2)^2-Q(3)^2-Q(4)^2 2.0*(Q(2)*Q(3)-Q(1)*Q(4)) 2.0*(Q(2)*Q(4)+Q(1)*Q(3))
     2.0*(Q(2)*Q(3)+Q(1)*Q(4)) Q(1)^2-Q(2)^2+Q(3)^2-Q(4)^2 2.0*(Q(3)*Q(4)-Q(1)*Q(2))
     2.0*(Q(2)*Q(4)-Q(1)*Q(3)) 2.0*(Q(3)*Q(4)+Q(1)*Q(2)) Q(1)^2-Q(2)^2-Q(3)^2+Q(4)^2];


    
