function [h] = MinEigen(A)
%Compute the eigenvector corresponding to the smallest eigenvalue.

[V, D] = eig(A);

v = diag(D); % Extract diagonals of D to form a column vector.

[m, ind] = min(v); % ind gives the index of minimal value of vector v.

h = V(:,ind);

