function [h] = MaxEigen(A)
%Compute the eigenvector corresponding to the largest eigenvalue.

[V, D] = eig(A);

v = diag(D); % Extract diagonals of D to form a column vector.

[m, ind] = max(v); % ind gives the index of maximal value of vector v.

h = V(:,ind);

