function [T] = Estimate_trans(fl, x, y, flow, W)
% Estimate translation direction once rotational parameters are determined.
% x and y are row vector.
% N is number of points.
% x- and y-component of the velocity is contained in flow. 

  N = length(x);
 
  l = flow + [-W(1)*x.*y/fl+W(2)*(fl+x.^2/fl)-W(3)*y
              -W(1)*(fl+y.^2/fl)+W(2)*x.*y/fl+W(3)*x];

  s = [x; y; fl*ones(1,N)];
  l = [l; zeros(1,N)];
  Q = cross(s, l);
  T = MinEigen(Q*Q');
