function [W] = Estimate_rot(fl, x, y, flow, T)
% Estimate rotation parameters once translation direction is determined.
% x and y are column vector.
% x- and y-component of the velocity is contained in 
% column vector u and v.

  u = flow(1,:)';
  v = flow(2,:)';

  A = [(fl^2+y.^2)*T(1)-x.*y*T(2)-fl*x*T(3)  ...
       -x.*y*T(1)+(fl^2+x.^2)*T(2)-fl*y*T(3) ...
       -fl*x*T(1)-fl*y*T(2)+(x.^2+y.^2)*T(3)    ];

  B = -fl*v*T(1)+ fl*u*T(2) + (-y.*u+x.*v)*T(3);

  W = -inv(A'*A) * A' * B;

