
  rot_mag = 4e-3;		% magnitude of camera rotation
  N = 50;  			% number of feature samples.

  ratio = 1;			% ratio of transl comp over rotational comp.
  fov = 90;			% field of view in degrees.
  noise_level = 0.0; 		% standard deviation of noise in pixels.
  im_pixels = 512;		% image size in pixels (for noise calculation)

% depth parameters
  Z_min = 2;			% minimum depth in focal lengths
  Z_max = 8;			% maximum depth in focal lengths

% actual translational and rotational parameters.
  actual_trans = [0 0 1];	% will be normalized below
  actual_rot = [1 0 0];		% will be normalized below

%  actual_trans = input('actual translation vector: ');
%  actual_rot = input('actual rotation vector: ');

  if any(actual_trans ~= 0),
     actual_trans = normr(actual_trans);
  end
  if any(actual_rot ~= 0),
     actual_rot = rot_mag .* normr(actual_rot);
  end
  R0 = rotation_matrix(actual_rot);

% determine the translation that for a point at the center of the
% image and at depth z_mid yields the same amount of image motion as a
% camera rotation by rot_mag radians.
  Z_mid = (Z_min+Z_max)/2;
  T0 = Z_mid*rot_mag;

  speed = ratio * T0;

  translation = speed * actual_trans;

  im_size = 2*tan(fov*pi/180/2);            	% image size in focal lengths

% reset seeds to get repeatable results
  rand('seed', 393090845);
  randn('seed', 967345454);

% image coordinates and depths (all in focal lengths)

% random clouds.
  x = im_size*(rand(1, N)-0.5);		% image x coordinates in focal lengths
  y = im_size*(rand(1, N)-0.5);		% image y coordinates in focal lengths
  Z = Z_min + (Z_max-Z_min)*rand(1,N);  % depth values in focal lengths

  flow = makeflow(x, y, Z, translation, actual_rot); % noise-free flow vector

% noise related to a nominal image of size im_pixels by im_pixels

  noise = (noise_level*im_size/im_pixels)*randn(2,N);

  noisy_flow = flow + noise;

  fid = fopen('data_file', 'w');
  for i=1:N
      fprintf(fid, '%f  %f  %f  %f\n', x(i), y(i), noisy_flow(1,i), noisy_flow(2,i));
  end

  fclose(fid);

