
function [est_trans] = subspace_trans(fl, x, y, flow)
% Implementation of Heeger and Jepson's linear subspace method for computing
% translation direction. Refer to "linear subspace methods for recovering 
% translation direction", pp. 39--62, Spatial Vision in Humans and Robots.

% x and y are row vector.
% x- and y-component of the velocity is contained in 
% the 1st and 2nd row of flow.

% Compute c vectors, where c is a matrix of N x (N-6),
% decomposed of the orthonormal basis of the null-space of F.

  N = size(x,2);
  F = [ones(1,N); x; y; x.^2; y.^2; x.*y];

  [u,s,v] = svd(F);
  c_vectors = v(:,7:N);

  Vx = flow(1,:)';
  Vy = flow(2,:)';
  Axp = [zeros(1,N); fl*ones(1,N); -y];
  Ayp = [-fl*ones(1,N); zeros(1,N); x];
  tau_matrix = zeros(3);

  for i = 1 : N-6
      c_vector = c_vectors(:,i);

     % Compute tau, which is 3 x 1 vector.
      tau = Axp * (c_vector .* Vx) + Ayp * (c_vector .* Vy);

     % Sum up the outer product of tau.
      tau_matrix = tau_matrix + tau * tau';
  end

  est_trans = MinEigen(tau_matrix);


