
function [est_trans, converge] = bilinear_subspace(fl, x, y, flow, init_est)

% Implementation of bilinear subspace method for computing translation 
% direction. Refer to "Passive navigation", pp. 3-20, v. 21, CGIP, 1983,
% and "Recovery of Egomotion and Segmentation of Independent Object Motion 
% Using the EM algorithm", pp. 13-16, BMVC'94.

% x and y are row vector.
% x- and y-component of the velocity is contained in 
% the 1st and 2nd row of flow.
% init_est is a row vector.

  u = flow(1,:)';
  v = flow(2,:)';
 
  OPTIONS = 0;
  OPTIONS(14) = 400;
%        OPTIONS(1) = 1;
      

  [est_trans, converge] = constr_modified('bilinear_fun', init_est, ...
                          OPTIONS, [], [], [], fl, x', y', u, v);


