function [E, G] = bilinear_fun(T, fl, x, y, u, v)
% Minimization function
% T is translation and rotation parameters.
% x and y are column vector.
% x- and y-component of the velocity is contained in 
% the 1st and 2nd row of flow.

  A = [(fl^2+y.^2)*T(1)-x.*y*T(2)-fl*x*T(3)  ...
       -x.*y*T(1)+(fl^2+x.^2)*T(2)-fl*y*T(3) ...
       -fl*x*T(1)-fl*y*T(2)+(x.^2+y.^2)*T(3)    ];
  B = -fl*v*T(1) + fl*u*T(2) + (-y.*u+x.*v)*T(3);

  W = -inv(A'*A) * A' * B;

  E = norm([B A] * [1; W]);

  G = abs(norm(T) - 1);


