
function [x,y,iter] = ruhe_wedin(B,b,x,maxiter)
% version II of the Ruhe-Wedin separable least squares minimization
% algorithm for the constant right-hand side problem tensor(B,x)*y = b

d = length(x);
A = rearrange(B,size(B,2)/d);
nr = norm(x);
x = x/nr;

%small = 1.0e-8; % Original value
small = 1.0e-4;
go_on = 1;
iter = 0;
while go_on,

  F = tensor(B,x);
  y = F\b;
  oldx = x;

  Urtilde = orthorange(F);
  Bx = tensor(A,y);
  B2 = Urtilde'*Bx;
  b2 = Urtilde'*b;

% B2 is rank 2; constrain the solution to be tangent to the sphere
% norm(x)=1, that is, orthogonal to the current x
  B2 = [B2; x'];
  b2 = [b2; 0];

  increment = B2\b2;

  x = x + increment;
  nr = norm(x);
  x = x/nr;
  y = y*nr;

  if norm(x-oldx) < small, go_on = 0; end
  iter = iter + 1;
  if iter >= maxiter,
    disp('Warning: maximum number of iterations exceeded');
    go_on = 0;
  end
end




