% orthogonal projector onto the orthogonal complement of range(A)

function Urtilde = orthorange(A)

[U S V] = svd(A);

% rank of A
tol = max(size(A)) * S(1,1) * eps;
r = sum(diag(S) > tol);

% Golub and Van Loan's notation (page 76)
Urtilde = U(:, r+1:size(U,2));
%Q = Urtilde*Urtilde';
