
function [eedges,triangles] = delaunay(x)
% given an nx2 matrix of plane point coordinates, returns labels for
% edges and triangles of a Delaunay triangulation; labels are numbered
% 1 through n; edges is 2xn, triangles is 3xn.

% x -- a nx2 matrix of plane point coordinates.
% triangles -- return the indices of points forming triangles.
%              Each column contains the indices of a triangle.
% eedges -- return the vertice of edges.

  n = size(x,1);
  t = x';
  z = triangulate(n, t(:));
  [i,j,s] = find(z);
  S = sparse(i,j,s);
  triangles = full(S);
  clear z i j s t S
  z = edges(size(triangles,2), triangles(:));
  [i,j,s] = find(z);
  S = sparse(i,j,s);
  eedges = full(S);

% the C programs label nodes starting with zeros; we want them to
% start with ones.
  eedges = eedges+1;
  triangles = triangles+1;

