function [alpha,alphadot] = anglederiv(P,Q,U,V)

[p,np] = normalized(P);
[q,nq] = normalized(Q);
cs = p'*q;
alpha = acos(cs);

sinalpha = sin(alpha);
if sinalpha == 0,
  error('angles between features cannot be zero or pi')
end

u = U/np;
v = V/nq;
alphadot = (cs * (p'*u + q'*v) - (p'*v + q'*u))/sinalpha;
