function [alpha,alphadot] = alphabeta(x, u, edges)

% transform x and u to homogeneous coordinates
one = ones(size(x, 1),1);
x(:,3) = one;
zero = zeros(size(u, 1),1);
u(:,3) = zero;

m = size(edges,1);
for k = 1:m,
  i = edges(k,1);
  j = edges(k,2);
  [alpha(k), alphadot(k)] = anglederiv(x(i,:)', x(j,:)', u(i,:)', u(j,:)');
end

