% compute the B matrix and the beta vector from the image
% measurements alpha1, alpha2; in the process, also creates a
% Delaunay triangulation of the points in x.

function [B,beta,edges] = Bbeta(x, u)

% Apply Delauny triangulation to the set of image points to
% get the group of independent equations. Edges connecting
% each triangle vertices form one equation.
  
  edges = delaunay(x)';
  m = size(edges, 1);

% make projection ray angles and their derivatives
  [alpha, alphadot] = alphabeta(x, u, edges);

% the n ray unit vectors
  n = size(x,1);
  x(:,3) = ones(n,1);
  clear N
  N = normr(x)';

% basic blocks of the system from inverse depths to measurements
  B = zeros(m,3*n);
  clear beta
  beta = (alphadot./sin(alpha))';
  for k=1:m,
      i = edges(k,1);
      j = edges(k,2);
      Bk = inv([N(:,i) N(:,j) normalized(cross(N(:,i),N(:,j)))]);
      i1 = 3*(i-1)+1;
      j1 = 3*(j-1)+1;
      B(k,i1:i1+2) = Bk(2,:);
      B(k,j1:j1+2) = Bk(1,:);
  end

