
function E = prazdny_fun(Z, s, v, n, triangles)
% Objective Minimization function
% Z is a vector of three unknown rotation parameters: Z = (wx, wy, wz).
% s -- 3 x N matrix: image coordinates at unit spherical retina.
% v -- 3 x N matrix: image velocities at unit spherical retina.
% triangles --  matrix of 3 x #triangles: indices of points of triangulation.

 p = zeros(n,1);
 A = Z'*ones(1,3);
 for i = 1:n
     node = triangles(:, i);
     S = [s(:,node(1))  s(:,node(2))  s(:,node(3))];
     V = [v(:,node(1))  v(:,node(2))  v(:,node(3))];
%     cross((cross(A,S)+V),S)
     p(i) = det(cross((cross(A,S)+V),S));
 end
 
% Scale the objective function since higher order polynomial of rotation gives
% very small function value.

 E = 1e15*sum(p.^2);
% E = sum(p.^2);
 


