function  [est_rot, converge] = prazdny(fl, x, y, flow, init_est)
% Implementation of Prazdny's rotation-first algorithm for sparse optical flow.
% Refer to "Egomotion and relative depth map from optical flow", pp. 87--102,
% v. 36, Biological Cybernetics, 1980. 

  N = length(x);

% Image coordinates (x,y,fl) at planar surface corresponds
% to (s1,s2,s3) at unit sphere.

  s = normc([x; y; fl*ones(1,N)]); % Normalize each column.
% This is a 3 x N matrix, where each column contains 
% a N-vector.

% Transform the image velocities at planar surface located 
% at z=fl to v at unit retina sphere.

  v = zeros(3, N);
  tmp = 1./sqrt(x.^2+y.^2+fl^2);  
  tmp1 = (x.*flow(1,:)+y.*flow(2,:)).*(tmp.^3);
  v(1,:) = tmp.*flow(1,:) - tmp1.*x;
  v(2,:) = tmp.*flow(2,:) - tmp1.*y;
  v(3,:) = -fl*tmp1;
% This is a 3 x N matrix, where each column contains 
% a velocity.

% Apply Delauny triangulation to the set of image points to
% get the group of independent equations. Three points in 
% each triangle will form one equation.
  
  triangles = triangulate(N, x, y) + 1;
% Each column contains the indices of points forming one triangles.
% The reason of adding 1 is that the starting index is 1 in Matlab
% whereas it is 0 in C code. The triangulation results from c-code.

  n = size(triangles, 2); 
% # triangles, i.e. # independent equations

  OPTIONS(2) = 1e-5;  % trade-off between accuracy and timing.

  [est_rot,OPTIONS] = fmins('prazdny_fun', init_est, OPTIONS, [], s, v, n, triangles);

  if OPTIONS(10) <= OPTIONS(14) % converge case.
     converge = 1;
  else
     converge = 0;
  end