
/* Matlab MEX file */

#include "mex.h"
#include <stdio.h>
#include "defs.h"
struct Site *readone();
struct Site *nextone();

triangulation(N, in_data, out_data)
int  N;
double *in_data, *out_data;
{	
struct Site *(*next)();

sorted = 0; triangulate = 1; plot = 0; debug = 0;

freeinit(&sfl, sizeof *sites);
if(sorted)
{	scanf("%d %f %f %f %f", &nsites, &xmin, &xmax, &ymin, &ymax);
	next = readone;
}
else 
{	readsites(N, in_data);
	next = nextone;
};

siteidx = 0;
geominit();
if(plot) plotinit();

voronoi(triangulate, next, out_data); 

}

/* sort sites on y, then x, coord */
int scomp(s1,s2)
struct Point *s1,*s2;
{
	if(s1 -> y < s2 -> y) return(-1);
	if(s1 -> y > s2 -> y) return(1);
	if(s1 -> x < s2 -> x) return(-1);
	if(s1 -> x > s2 -> x) return(1);
	return(0);
}

/* return a single in-storage site */
struct Site *nextone()
{
struct Site *s;
if(siteidx < nsites)
{	s = &sites[siteidx];
	siteidx += 1;
	return(s);
}
else	return( (struct Site *)NULL);
}


/* read all sites, sort, and compute xmin, xmax, ymin, ymax */
readsites(N, in_data)
int   N;
double *in_data;
{
int i;
sites = (struct Site *) myalloc(N*sizeof *sites);
for(nsites=0; nsites<N; nsites++) {
        sites[nsites].coord.x = in_data[2*nsites];
        sites[nsites].coord.y = in_data[2*nsites+1];
	sites[nsites].sitenbr = nsites;
	sites[nsites].refcnt = 0;
}
nsites = N;
qsort(sites, nsites, sizeof *sites, scomp);
xmin=sites[0].coord.x; 
xmax=sites[0].coord.x;
for(i=1; i<nsites; i+=1)
{	if(sites[i].coord.x < xmin) xmin = sites[i].coord.x;
	if(sites[i].coord.x > xmax) xmax = sites[i].coord.x;
};
ymin = sites[0].coord.y;
ymax = sites[nsites-1].coord.y;
}

/* read one site */
struct Site *readone()
{
struct Site *s;

s = (struct Site *) getfree(&sfl);
s -> refcnt = 0;
s -> sitenbr = siteidx;
siteidx += 1;
if(scanf("%f %f", &(s->coord.x), &(s->coord.y)) == EOF)
	return ((struct Site *) NULL );
return(s);
}

/* Gateway routine: #define output plhs[0]; */

void mexFunction(int nlhs,   /* number of arguments on lhs */
		 Matrix	*plhs[],   /* Matrices on lhs      */
		 int nrhs,	   /* no. of mat on rhs    */
		 Matrix	*prhs[]    /* Matrices on rhs      */
		 )
{
  double  *Np, *in_data, *out_data;
  int     N;

  /* Check for proper number of arguments */

    if (nrhs < 2)
      mexErrMsgTxt("trig.c needs at least two arguments.");

    Np = mxGetPr(prhs[0]);
    N = *Np;
    
    plhs[0]=mxCreateFull(3, 2*N-4,REAL); 
         /* 2N-4 is maximal number of triangles */

  /* Dereference arguments and call the computational routine. */
    in_data = mxGetPr(prhs[1]);
    out_data = mxGetPr(plhs[0]);

    triangulation(N, in_data, out_data);
}




