
/* Form edges from Delauny triangulation. */

#include "mex.h"
#include <stdio.h>
#include "defs.h"

#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))

typedef struct
{
  int a, b;
}
edge;

edge *edgelist(n, in_data)
int n; /* number of triangles */
double  *in_data;
{
  edge *e;
  int  i, k, a[4];

  e = (edge*)calloc(3*n,sizeof(edge));
  if (e == (edge*)0)
    {
      fprintf(stderr, "calloc returned 0\n");
      exit(1);
    }

  for (i=0; i<n; i++) 
    {
      a[0] = in_data[3*i];
      a[1] = in_data[3*i+1];
      a[2] = in_data[3*i+2];
      a[3] = a[0];

      for (k=0; k < 3; k++)
	{
	  e[3*i+k].a = MIN(a[k], a[k+1]);
	  e[3*i+k].b = MAX(a[k], a[k+1]);
	}
    }
  return e;
}

int compare(e,f)
edge *e,*f;
{
  if (e->a < f->a) return -1;
  if (e->a == f->a && e->b < f->b) return -1;
  if (e->a == f->a && e->b == f->b) return 0;
  return 1;
}

void writeunique(e, n, out_data)
edge *e;
int n;
double *out_data;
{
  int i, k;

  out_data[0] = e[0].a;
  out_data[1] = e[0].b;

  k = 1;

  for (i=1; i < n; i++)
    if (compare(&e[i-1],&e[i]) != 0) {
        out_data[2*k] = e[i].a;
        out_data[2*k+1] = e[i].b;
        k++;
      }
}

edges(n, in_data, out_data)
int    n;  /* number of triangles. */
double *in_data, *out_data; /* triangle vertices and edge vertices. */
{
  edge *e;

  e = edgelist(n, in_data);
  qsort(e,3*n,sizeof(edge),compare);
  writeunique(e,3*n,out_data);
}

/* Matlab MEX file */

/* Gateway routine: #define output plhs[0]; */

void mexFunction(int nlhs,   /* number of arguments on lhs */
		 Matrix	*plhs[],   /* Matrices on lhs      */
		 int nrhs,	   /* no. of mat on rhs    */
		 Matrix	*prhs[]    /* Matrices on rhs      */
		 )
{
  double  *Np, *in_data, *out_data;
  int     N;

  /* Check for proper number of arguments */

    if (nrhs < 2)
      mexErrMsgTxt("edges.c needs at least two arguments.");

    Np = mxGetPr(prhs[0]);
    N = *Np;
    
    plhs[0]=mxCreateFull(2, 3*N,REAL); 
         /* Each triangle can form at most three edges. */

  /* Dereference arguments and call the computational routine. */
    in_data = mxGetPr(prhs[1]);
    out_data = mxGetPr(plhs[0]);

    edges(N, in_data, out_data);
}




